/*
 * Settings
 * HeatBox NG
 * (c) hadi-rc.de
 */
 
 
/* ------------------- Systemintern ------------------- */ 

const byte settings_version             = 1;             //Setingsversion - Änderung erzwingt Reset der Werte im EEPRom
const byte version[3]                   = {0,0,4};       //Software-Version (Major,Minor,Build)
const byte eepromCapaSlots              = 230;           //Anzahl nutzbarer Speicher-Slots. Wird von Hinten beginnend gezählt (Letzter Slot ist also 1023 - Slotgröße (4 Bytes))

/* ------------------- Sensoren ------------------- */
 
const unsigned int abs_max_vin          = 200;           //Maximale Spannung an der Gesamtspannungsmesseinrichtung. Wert mit 10 multiplizieren (12.5V = 125)
const unsigned int isensorMaxmA         = 25000;         //Maximaler Messwert des Stromsensors in mA (nicht der "Aufdruck" am Chip ist wichtig, sondern der theoretische Strom bei 5V am Mess-Ausgang... der 20A Sensor macht z.B. 25A)

/* ------------------- Pin Konfiguration ------------------- */
 
#define pin_wirebus              7
#define pin_gesamtspannung      A0
#define pin_stromsensor         A1
#define pin_internextern        A2
#define pin_backgroundled        9
#define pin_left                 2
#define pin_right                0
#define pin_enter                1
#define pin_buzzer               11
#define pin_ventilator           8
#define pin_heizung              5
#define pin_intext              A2        //Intern-/Extern-Erkennung
#define intextMinRead           50        //Mindestwert (0-1023) der gelesen werden muss damit der Messwert als HIGH Interpretiert wird und auf externe Versorgung umgestellt wird

/* ------------------- Intervalle ------------------- */

const unsigned int loop_intervall_default =500;          //Pause in ms zwischen den einzelnen Zyklen wenn die Übersicht angezeigt wird
const unsigned int loop_intervall_menu    =200;          //Pause in ms zwischen den einzelnen Zyklen wenn ein Menü angezeigt wird
const unsigned int loop_intervall_sensors =300;          //Pause in ms zwischen den einzelnen Zyklen in denen die Sensorwerte abgefragt werden. Unter 300 ist wegen der T-Sensor-Bibliothek nicht zu erreichen (ggf T-Sensor-Bibliothek überarbeiten und in zwei Takten arbeiten)

/* ------------------- Buttons ------------------- */

const  byte button_debounce               = 30;          //Anzahl Millisekunden zwischen zwei gültigen Knopfdrücken
const unsigned int akkuResetDelay         = 2000;        //Anzahl Millisekunden die der Reset-Knopf im Hauptschirm gehalten werden muss bis der Akku-Reset durchgeführt wird
const unsigned int longPressDelay         = 1000;        //Anzahl millisekunden die vergehen müssen bevor ein Gedrückthalten als "LongPress" akzeptiert wird

const byte temperatur_slow_step           = 1;           //Schrittweite für Temperaturwerte bei einmaligen Drücken
const byte temperatur_fast_step           = 5;           //Schrittweite für Temperaturwerte bei gedrückt halten

const byte time_slow_step                 = 1;           //Schrittweite für Zeitwerte bei einmaligen Drücken
const byte time_fast_step                 = 5;           //Schrittweite für Zeitwerte bei gedrückt halten

const unsigned int capa_slow_step         = 10;          //Schrittweite für Kapazitätswerte bei einmaligen Drücken
const unsigned int capa_fast_step         = 200;         //Schrittweite für Kapazitätswerte bei gedrückt halten

const unsigned int button_isfast          = 1500;        //Wird innerhalb der angegebenen Zeit in ms der Knopf nicht wieder losgelassen werden die Werte schneller erhöht
const unsigned int isfast_tick            = 200;         //Wenn der Knopf gedrückt gehalten wird, alle wie viel ms soll der jeweilige Wert erhöht werden   

/* ------------------- States ------------------- */

#define state_default                0

#define state_penter                10
//#define state_preset              11
#define state_ptimer                11
#define state_psetup                12
#define state_pinfo                 13
#define state_pback                 14

#define state_senter                30
#define state_smaxtemp              31
#define state_shyster               32
#define state_sakkutype             33
#define state_sakkucapa             34
#define state_sakkucut              35
#define state_sakkudowarn           36
#define state_sakkuwarn             37
#define state_sheatpause            38
#define state_sheatpauseduration    39
#define state_sfanduration          40
#define state_sfanpause             41
#define state_sstoreeeprom          42
#define state_ssavesettings         43
#define state_sback                 44

#define state_showreset             50
#define state_timermenu             60
#define state_info                  70

/* ------------------- Presets ------------------- */

#define preset_max_temp                38      //Standartwert Zieltemperatur
#define preset_hysterese               30      //Standartwert Hyterese
#define preset_akku_type                0      //Standartwert Akku-Typ
#define preset_akku_size             5000      //Standartwert Akkukapazität
#define preset_akku_warn             4000      //Standartwert Warnkapazität
#define preset_akku_cut              4500      //Standartwert Abschaltkapazität
#define preset_do_akkuwarn           true      //Standartwert ob eine Warnung bei sich leerendem Akku ausgegeben werden soll
#define preset_heat_pause              60      //Standartwert für Konvktionspausenintervall
#define preset_heat_pauseduration      10      //Dauer der Konvektionspause in Sekunden

#define preset_fan_duration            15      //Ventilator-Laufzeit in Sekunden
#define preset_fan_pause               60      //Ventilator-Pausen in Sekunden


#define preset_storeCapa             true      //Standartwert ob die verbrauchte Kapazität in das EEPROM gespeichert werden soll

#define abs_min_temp                   25      //Absolute Mindesttemperatur die man einstellen kann
#define abs_max_temp                   50      //Absolute Maximaltemperatur die man einstellen kann
#define abs_max_hysterese              15      //Maximale Temperaturdifferenz für die Hysterese
#define abs_min_hysterese               1      //Minimale Temperaturdifferent für die Hysterese

#define abs_max_batt                30000      //Absolute Maximalkapazität die man für den Akku einstellen kann
//#define abs_max_heat_pause           60      //Absolut maximale Pausen-Länge für die Konvektionspause

#define abs_min_fanduration             0      //Mindestwert der Nutzereingabe für Ventilatorlaufzeit
#define abs_max_fanduration           120      //Höchstwert der Nutzereingabe für Ventilatorlaufzeit
#define abs_min_fanpause                0      //Mindestwert der Nutzereingabe für Ventilatorpause
#define abs_max_fanpause              120      //Höchstwert der Nutzereingabe für Ventilatorpause
#define abs_min_heatpause               0      //Mindestwert der Nutzereingabe für das Heizpausenintervall
#define abs_max_heatpause             120      //Höchstwert der Nutzereingabe für das Heizpausenintervall
#define abs_min_heatpauseduration       0      //Mindestwert der Nutzereingabe für die Heizpause
#define abs_max_heatpauseduration     120      //Höchstwert der Nutzereingabe für die Heizpause

/* ------------------- Akkutypen ------------------- */


const byte countAkkuTypes               = 6;               //Anzahl der AkkuTypen die definiert werden. Workaround, da es kein array.length() gibt, wir aber sicherstellen müssen nicht hinter das ArrayEnde zu lesen
const String akku_names[countAkkuTypes] = {"LiPo","LiFe", "LiIon","NiXX","PB"};
const byte   akku_volts[countAkkuTypes] = {99 , 108 , 96, 95 , 112};          //Akkuspannungen in Volt*10  (9,9V = 99, 11,2V = 112, etc)

/* ------------------- Status-Informationen ------------------- */

//System-Statis (8bit)
const byte syst_externeQuelle       = B00000001;      //System wird mit externer Quelle betrieben

//Fehler und Warnungen -Statis (8Bit)
const byte fehler_keiner            = B00000000;      //Alles ok
const byte fehler_AkkuLeer          = B00000001;      //Akku ist leer
const byte fehler_AkkuWarnung       = B00000010;      //Akku-Warnschwelle erreicht
const byte fehler_AkkuSpannung      = B00000100;      //Akku-Mindestspannung unterschritten
const byte fehler_tSensorFehler     = B00001000;      //Fehler im Temperatursensor-Subsystem
//const byte syst_keinHeizelement   = B00010000;      //kein Heizelement erkannt

//Heizungs-Statis(8Bit)
const byte heizung_aus              = B00000000;      //Heizung inaktiv (ohne Grund)
const byte heizung_an               = B00000001;      //Heizung aktiv
const byte heizung_hyterese         = B00000010;      //Hyteresen-Pause
const byte heizung_konvektion       = B00000100;      //Konvektionspause
const byte heizung_gesperrt         = B10000000;      //Heizfunktion aufgrund eines Fehlercodes gesperrt





