static struct settings_t {                    //Datenstruktur zum Speichern in den EEPROM des Prozessors (speichert  Nutzer-Werte)
  uint8_t       max_temp;                     //maximal-Temperatur. Steigt der Messwert datüber wird die Heizung abgeschaltet
  uint8_t       hysterese;                    //Hysterese-Differenz
  byte          akku_type;                    //verwendeter Akku-Typ. Hieraus definiert sich z.B. die Abschaltspannung. (Akku-Schutz)
  unsigned int  akku_size;                    //speichert die angegebene Kapazität des Akkus in mAh
  unsigned int  akku_warn;                    //ab diesem Verbrauchswert wird ein Warnton ausgegeben. (Akku-Schutz)
  unsigned int  akku_cut;                     //ab diesem Verbrauchswert wird das heizen eingestellt. (Akku-Schutz)
  boolean       do_akkuwarn;                  //TRUE wenn der Nutzer eine Warnschwelle wünscht, FALSE wenn nicht
  uint8_t       heat_pause;                   //speichert den Abstand zwischen den Heizpausen
  uint8_t       heat_pauseduration;           //speichert die Pausenlänge (in Sekunden) in der die Heizperiode unterbrichen werden soll (Konvektionspause)
  uint8_t       fan_duration;                 //Laufzeit des Lüfters
  uint8_t       fan_pause;                    //Pausenzeit des Lüfters
  boolean       storeEEPROM;                  //Soll Kapazität in das EEPROM gepsiehcert werden?
  byte          firstrun;                     //ist 0 wenn noch nie ein Setup durchgeführt wurde ("Erststart"), sonst 1
  byte          setversion;                   //speichert die aktuelle Version dieser Datenstruktur - wenn ein Update eingespielt wird das eine hoehere Versionsnummer der Datenstruktur hat, wird das EEPROM einmal gelöscht
} settings;



static struct sensorvalues_t {
  uint8_t       voltage;                      //Spannungs-Wert
  int           temperature;                  //Temperaturwert
  unsigned long mah;                          //verbrauchte Kapazität
  byte          percent;                      //Restkapazität in Prozent
} sensorValues = {0,0,0,0};



/*
static struct errors_t {
  boolean warnschwelle;
  boolean abschaltschwelle;
  boolean spannung;
  
  boolean keinSensor;
  boolean sensorWert;
  
  boolean heizung;
} errors;
*/
