/*
 * EEPRom Bibliothek
 * HeatBox NG
 * (c) hadi-rc.de
 */
byte capaOffset=0;
 
void readCapa(){
  /* Ließt die Kapazität aus dem EEPRom an der Stelle, die sich anhand des Offsets berechnet.
   * Anschließend wird ein neues Offset generiert, welches bis zum Abschalten gültig ist.
   * Dieses neue Offset wird ebenfalls gespeichert.
   *
   * Berechnung: 1023Bytes - 4Bytes -      offset*4Bytes
   *             vvvvvvvvvvvvvvvvvv   vvvvvvvvvvvvvvvvvvvvvv
   *                = 1019            = Adressierung (0-229)
   *
   * = 1019 - offset*4
   */
   
  eeprom_read_block((void*)&sensorValues.mah , (void*)(1019-(capaOffset*4)) , sizeof(sensorValues.mah));
  Serial.print("reading Capa: ");
  Serial.print(sensorValues.mah);
  Serial.print(" from Offset: ");
  Serial.println(capaOffset);
}


//--------------------------------------------------------------------------------


void writeCapa(){
  /* Schreibt die Kapazität aus dem EEPRom an der Stelle, die sich anhand des Offsets berechnet.
   *
   * Berechnung: 1023Bytes - 4Bytes -      offset*4Bytes
   *             vvvvvvvvvvvvvvvvvv   vvvvvvvvvvvvvvvvvvvvvv
   *                = 1019            = Adressierung (0-229)
   *
   * = 1019 - offset*4
   */
  eeprom_write_block((const void*)&sensorValues.mah , (void*)(1019-(capaOffset*4)) , sizeof(sensorValues.mah));
  Serial.print("writing Capa: ");
  Serial.print(sensorValues.mah);
  Serial.print(" to Offset: ");
  Serial.println(capaOffset);
}


//--------------------------------------------------------------------------------


void readCapaOffset(){
  /* Ließt den Offset-Wert.
   * Angenommen wird, dass der Offset im 100. Byte ( Adresse 99 ) steht.
   */
  eeprom_read_block((void*)&capaOffset, (void*)99, 1);
  Serial.println("reading Offset");
}


//--------------------------------------------------------------------------------


void writeCapaOffset(){
  /* Schreibt den Offset-Wert.
   * Angenommen wird, dass der Offset im 100. Byte ( Adresse 99 ) steht.
   * der Wert des Capa Offset wird vor dem Schreiben erhöht.
   */
   capaOffset++;
   if(capaOffset>eepromCapaSlots) {
     capaOffset=0;
   }
   eeprom_write_block((void*)&capaOffset, (void*)99, 1);
   Serial.print("generated new Offset: ");
   Serial.println(capaOffset);
}


//--------------------------------------------------------------------------------


void eepromReadSettings() {
  /* Ließt die Settings.
   * Angenommen wird, dass die settings beim Byte 0 beginnen.
   */
   eeprom_read_block((void*)&settings, (void*)0, sizeof(settings));
}

//--------------------------------------------------------------------------------

void eepromWriteSettings() {
  /* Schreibt die Settings.
   * Angenommen wird, dass die settings beim Byte 0 beginnen.
   */
   eeprom_write_block((const void*)&settings, (void*)0, sizeof(settings));
}

//--------------------------------------------------------------------------------

void clear_eeprom(){
  /* Löscht das komplette EEPROM.
   * 
   */
   
}

//--------------------------------------------------------------------------------
